# MySQL Kurulum Rehberi

## Adım 1: MySQL Veritabanı Oluşturma

MySQL'e bağlanın ve yeni bir veritabanı oluşturun:

```sql
CREATE DATABASE ticket_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

Veya MySQL komut satırından:
```bash
mysql -u root -p
```

Sonra:
```sql
CREATE DATABASE ticket_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
EXIT;
```

## Adım 2: .env Dosyasını Yapılandırma

Proje kök dizininde `.env` dosyası oluşturun (`.env.example` varsa kopyalayın):

```bash
cp .env.example .env
```

`.env` dosyasını açın ve MySQL ayarlarını yapın:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=ticket_system
DB_USERNAME=root
DB_PASSWORD=your_mysql_password
```

**Önemli:** `DB_PASSWORD` kısmına MySQL root şifrenizi yazın. Eğer şifre yoksa boş bırakabilirsiniz.

## Adım 3: Composer Bağımlılıklarını Yükleme

```bash
composer install
```

## Adım 4: Uygulama Anahtarı Oluşturma

```bash
php artisan key:generate
```

## Adım 5: Veritabanı Migration'larını Çalıştırma

```bash
php artisan migrate
```

Bu komut tüm tabloları oluşturacak:
- users
- tickets
- ticket_replies
- ticket_attachments
- knowledge_base
- settings
- password_reset_tokens
- sessions

## Adım 6: (Opsiyonel) Varsayılan Kullanıcıları Oluşturma

Seeder'ı çalıştırarak varsayılan admin ve test kullanıcısı oluşturun:

```bash
php artisan db:seed
```

Varsayılan giriş bilgileri:
- **Admin:** admin@example.com / password
- **Kullanıcı:** user@example.com / password

## Adım 7: Storage Link Oluşturma

Dosya yüklemeleri için:

```bash
php artisan storage:link
```

## Adım 8: NPM Bağımlılıklarını Yükleme

```bash
npm install
```

## Adım 9: Sunucuyu Başlatma

Terminal 1 - Laravel sunucusu:
```bash
php artisan serve
```

Terminal 2 - Vite (CSS/JS için):
```bash
npm run dev
```

Tarayıcıda `http://localhost:8000` adresine gidin.

## Sorun Giderme

### MySQL Bağlantı Hatası

Eğer "Access denied" hatası alırsanız:

1. MySQL kullanıcı adı ve şifresini kontrol edin
2. MySQL servisinin çalıştığından emin olun:
   ```bash
   # macOS
   brew services list
   
   # Linux
   sudo systemctl status mysql
   
   # Windows
   # Services panelinden MySQL'i kontrol edin
   ```

### Veritabanı Bulunamadı Hatası

Veritabanının oluşturulduğundan emin olun:
```sql
SHOW DATABASES;
```

### Migration Hatası

Eğer migration'lar çalışmazsa:
```bash
php artisan migrate:fresh
```

Bu komut tüm tabloları siler ve yeniden oluşturur (DİKKAT: Veriler silinir!).

## MySQL Kullanıcı Oluşturma (Önerilen)

Güvenlik için özel bir MySQL kullanıcısı oluşturmanız önerilir:

```sql
CREATE USER 'ticket_user'@'localhost' IDENTIFIED BY 'güçlü_şifre';
GRANT ALL PRIVILEGES ON ticket_system.* TO 'ticket_user'@'localhost';
FLUSH PRIVILEGES;
```

Sonra `.env` dosyasında:
```env
DB_USERNAME=ticket_user
DB_PASSWORD=güçlü_şifre
```

